# Vespucci 19.3 Highlights

2023-10-27

### End of support for Android 4.1 to 4.4 in 2024 announcement

For version 20 that will likely be released early next year, we intend to drop support for Android version prior to Android 5, this will effect devices running 4.1 to 4.4. These Android versions are at this point more than a decade old and have become difficult to support going forward and as you know we already have to distribute a separate build now.

If this causes a significant issue for you, please open an issue on the Vespucci github repository.

### Improvements layer styling

Layers that can have multiple instances and can be styled via the UI (GPX, GeoJSON, MVT) are now automatically assigned varying colours when they are created, the same applies to feature layers in MVT layers that do not have a Mapbox GL style loaded. 

For GPX and GeoJSON certain style setting (marker type, stroke width, label source) are now initialized to the last used value.

### Mapillary date filter

Both sequences and images on the Mapillary layer can now be filtered by a date range. Select the overflow/hamburger menu for the layer and select "Set date range...". 

### PMTiles support

PMTiles is a "cloud native" container format for map tiles from Brandon Liu that for certain use cases offers advantages over the widely in use MBTiles format. We support PMTiles both as local and remote custom imagery sources. See [custom imagery help](Custom%20imagery.md).

### OSM element location indication in disambiguation menu

In some situations, particularly when multiple similar OSM elements without differentiating features are close to each other, it may be difficult to select the correct element. We've now added arrows indicating the location relative to the touch location to the disambiguation menu that can potentially help. Note that in general we recommend to zoom in more as a better way to  resolve such issues.

### 'Safe' mode improvements

In 19.1 we added an initial "Safe" mode to support recovering from some error states on startup of the app without having to delete the apps data, we've expanded it now to include three options

 - Set data style to minimal (default on)
 - Disable all layers (default on)
 - Remove saved state (default off)
 
The 1st two options are non-destructive and can be easily undone once the app has started, this is typically useful if a specific layer is causing an issue. The last option will remove the 
saved OSM data state including all edits, this is mainly useful if the data has become corrupted or for example if you are running out of memory. While this will delete any pending edits, you should still be able to retrieve them via the auto-save feature.

To start the app in Safe mode in launchers that support short cuts, long press the app icon and select _Safe_.

## Miscellaneous

- Add include relations with appropriate level tags in indoor mode
- Improve diagnostics when GetCapabilties fails
- Add more digits to offset display and show approximation in meters
- Support long text modal in additional items
- Support for uploading GPX waypoints
- If a custom icon is specified include preset icons in search
- Support queuing for toasts

# Upgrading from previous versions

* As the saved state file may have changed you should upload any pending changes before updating.

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
